package ubuntuaudit

import (
	"io"
	"sync"

	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
)

type Analyzer struct {
	yadi      *analyze.Analyzer
	savedOpts analyze.Options
	lock      sync.RWMutex
}

func NewAnalyzer(opts analyze.Options) (*Analyzer, error) {
	yadi, err := analyze.New(opts)
	if err != nil {
		return nil, err
	}

	return &Analyzer{
		yadi:      yadi,
		savedOpts: opts,
	}, nil
}

func (a *Analyzer) AnalyzePkg(codeName, pkgName, pkgVer string) (analyze.Issues, error) {
	a.lock.RLock()
	defer a.lock.RUnlock()

	if pkgVer == "" {
		pkgVer = "0.0.0"
	}

	dpkgManager := newSinglePkgManager(codeName, pkgName, pkgVer)
	result, err := a.yadi.CheckPackages(dpkgManager)
	if err != nil {
		return nil, err
	}

	if len(result) == 0 {
		return nil, nil
	}

	return result[0].Vulnerabilities, nil
}

func (a *Analyzer) AnalyzeMulti(codeName string, status io.Reader) (analyze.CheckPackagesResult, error) {
	a.lock.RLock()
	defer a.lock.RUnlock()

	dpkgManager := newMultiPkgManager(codeName, status)
	return a.yadi.CheckPackages(dpkgManager)
}

func (a *Analyzer) Reload() error {
	a.lock.Lock()
	defer a.lock.Unlock()

	yadi, err := analyze.New(a.savedOpts)
	if err != nil {
		return err
	}

	a.yadi = yadi
	return nil
}
