package ubuntuaudit

import (
	"io"
	"strings"

	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/dpkg"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/manager"
)

type multiPkgManager struct {
	codeName   string
	dpkgStatus io.Reader
}

func newMultiPkgManager(codeName string, dpkgStatus io.Reader) *multiPkgManager {
	return &multiPkgManager{
		codeName:   codeName,
		dpkgStatus: dpkgStatus,
	}
}

func (m *multiPkgManager) Name() string {
	return "ubuntu-multi-pkg-manager"
}

func (m *multiPkgManager) Distributive() string {
	return "linux-ubuntu"
}

func (m *multiPkgManager) DistributiveCodename() string {
	return strings.ToLower(m.codeName)
}

func (m *multiPkgManager) Packages() ([]*manager.Package, error) {
	return dpkg.ParseStatusData(m.dpkgStatus)
}
