package ubuntuaudit

import (
	"strings"

	"a.yandex-team.ru/security/yadi/yadi-os/pkg/debversion"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/manager"
)

type singlePkgManager struct {
	codeName, pkgName, pkgVersion string
}

func newSinglePkgManager(codeName, pkg, version string) *singlePkgManager {
	return &singlePkgManager{
		codeName:   codeName,
		pkgName:    pkg,
		pkgVersion: version,
	}
}

func (m *singlePkgManager) Name() string {
	return "ubuntu-single-pkg-manager"
}

func (m *singlePkgManager) Distributive() string {
	return "linux-ubuntu"
}

func (m *singlePkgManager) DistributiveCodename() string {
	return strings.ToLower(m.codeName)
}

func (m *singlePkgManager) Packages() ([]*manager.Package, error) {
	parsedVersion, err := debversion.NewVersion(m.pkgVersion)
	if err != nil {
		return nil, err
	}

	pkg := manager.Package{
		Name:             m.pkgName,
		Version:          parsedVersion,
		RawVersion:       m.pkgVersion,
		SourceName:       m.pkgName,
		SourceVersion:    parsedVersion,
		RawSourceVersion: m.pkgVersion,
	}

	result := make([]*manager.Package, 1)
	result[0] = &pkg
	return result, nil
}
