package unistat

import "sync/atomic"

type Counter struct {
	Request        uint64
	Audit          uint64
	Install        uint64
	AdvisoriesBulk uint64
	Timeout        uint64
	NotVulnerable  uint64
	Vulnerable     uint64
	UpdateFails    uint64
}

func NewCounter() *Counter {
	return &Counter{}
}

func (c *Counter) AddRequest() {
	atomic.AddUint64(&c.Request, 1)
}

func (c *Counter) AddAudit() {
	atomic.AddUint64(&c.Audit, 1)
}

func (c *Counter) AddInstall() {
	atomic.AddUint64(&c.Install, 1)
}

func (c *Counter) AddAdvisoriesBulk() {
	atomic.AddUint64(&c.AdvisoriesBulk, 1)
}

func (c *Counter) AddTimeout() {
	atomic.AddUint64(&c.Timeout, 1)
}

func (c *Counter) AddNotVulnerable() {
	atomic.AddUint64(&c.NotVulnerable, 1)
}

func (c *Counter) AddVulnerable() {
	atomic.AddUint64(&c.Vulnerable, 1)
}

func (c *Counter) AddUpdateFail() {
	atomic.AddUint64(&c.UpdateFails, 1)
}

func (c *Counter) Flush() Counter {
	return Counter{
		Audit:          atomic.SwapUint64(&c.Audit, 0),
		Install:        atomic.SwapUint64(&c.Install, 0),
		AdvisoriesBulk: atomic.SwapUint64(&c.AdvisoriesBulk, 0),
		Timeout:        atomic.SwapUint64(&c.Timeout, 0),
		NotVulnerable:  atomic.SwapUint64(&c.NotVulnerable, 0),
		Vulnerable:     atomic.SwapUint64(&c.Vulnerable, 0),
		UpdateFails:    atomic.SwapUint64(&c.UpdateFails, 0),
	}
}

func (c *Counter) FlushSignals() [][]interface{} {
	return [][]interface{}{
		{"request_summ", atomic.SwapUint64(&c.Request, 0)},
		{"audit_summ", atomic.SwapUint64(&c.Audit, 0)},
		{"install_summ", atomic.SwapUint64(&c.Install, 0)},
		{"bulk_summ", atomic.SwapUint64(&c.AdvisoriesBulk, 0)},
		{"timeout_summ", atomic.SwapUint64(&c.Timeout, 0)},
		{"not-vulnerable_summ", atomic.SwapUint64(&c.NotVulnerable, 0)},
		{"vulnerable_summ", atomic.SwapUint64(&c.Vulnerable, 0)},
		{"update_fails", atomic.SwapUint64(&c.UpdateFails, 0)},
	}
}
