package watcher

import (
	"a.yandex-team.ru/drive/library/go/cron"
	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/snatcher/pkg/manifestor"
)

const hourly = "0 * * * * *"

type Option func(w *FeedWatcher)

func WithManifestManager(manifestor *manifestor.Manifestor) Option {
	return func(w *FeedWatcher) {
		w.manifestor = manifestor
	}
}

func WithFeedToWatch(feed string) Option {
	return func(w *FeedWatcher) {
		w.feedURI = feed
	}
}

func WithReloadHandler(language, name string, f ReloadFunc) Option {
	return func(w *FeedWatcher) {
		w.reloadHandlerSpecs = append(w.reloadHandlerSpecs, reloadFuncSpec{
			name:     name,
			language: language,
			f:        f,
		})
	}
}

func WithCronSchedule(spec string) Option {
	return func(w *FeedWatcher) {
		scheduler, err := cron.Parse(spec)
		if err != nil {
			simplelog.Error("invalid cron error", "err", err)
			scheduler, _ = cron.Parse(hourly)
		}
		w.scheduler = scheduler
	}
}

func WithFetchers(fetchers ...FetchCleaner) Option {
	return func(w *FeedWatcher) {
		w.fetchers = fetchers
	}
}

func WithFailCounter(fail func()) Option {
	return func(w *FeedWatcher) {
		w.fail = fail
	}
}
