import requests


class Ampelmann(object):
    base_url = ""
    token = ""

    def __init__(self, base_url, token):
        self.base_url = base_url
        self.token = token

    def get_metrics(self, abc_id):
        result = {}
        payload = {"format": "json"}
        headers = {"Authorization": "OAuth " + self.token}
        url = self.base_url + "/metrics/services/api"

        if str(abc_id).isdigit():
            url += "/" + str(abc_id)

        try:
            r = requests.get(url, params=payload, headers=headers)
            if r.status_code != 200:
                return {}
            result = r.json()
        except:
            return {}

        return result
