import requests
import json


class AppsecDiscovery(object):
    def __init__(self, token, api_url):
        self.api_url = api_url
        self.token = token

        self.headers = {
            "X-API-Key": token,
        }

    def get_events(self, start_date, finish_date, service, event_type="release"):
        url = (
            "https://%s/api/for_services/object_search/%s/"
            "?start_date=%s&finish_date=%s&event_type=%s"
            % (self.api_url, service, start_date, finish_date, event_type)
        )

        r = requests.get(url, headers=self.headers)

        if r.status_code != 200:
            return []
        else:
            try:
                data = json.loads(r.text)
                if data["code"] != 200:
                    return []
                return data["result"]
            except Exception:
                return []

    def get_service_queues(self, service):
        url = "https://%s/api/for_services/search_childs/" % self.api_url
        data = {
            "ancestor_type": "service",
            "ancestor_field_name": "slug",
            "ancestor_field_value": service,
            "child_type": "queue",
            "recursive": True,
        }
        headers = {"Content-Type": "application/json"}
        r = requests.post(
            url,
            data=json.dumps(data),
            headers=headers,
            verify="/etc/ssl/certs/ca-certificates.crt",
        )

        return [item["value"] for item in r.json()["objects"]]
