import requests
import json


class AppsecPipeline(object):
    def __init__(self, token, api_url):
        self.api_url = api_url
        self.token = token

        self.headers = {
            "USER-API-TOKEN": token,
        }

    def get_events(self, start_date, finish_date, service_slug):
        url = (
            "https://%s/user_api/issue/all/fresh/"
            "?from=%s&to=%s&organization_name=%s"
            % (self.api_url, start_date, finish_date, service_slug)
        )

        r = requests.get(url, headers=self.headers)

        if r.status_code != 200:
            return []
        else:
            try:
                data = json.loads(r.text)
                if data["code"] != 200:
                    return []
                return data["result"]
            except Exception:
                return []
