try:
    from urlparse import urlparse
except ImportError:
    from urllib.parse import urlparse

#
# TODO
# What about mobile apps?
#


class Bugbounty(object):
    def __init__(self, config):
        self.scope = [i.strip() for i in config.get("bugbounty", "scope").split(",")]

    def get_status_by_service(self, service):
        url = service.get_contact_by_type("url_sitelink", "")
        return self.get_status_by_url(url)

    def get_status_by_url(self, url):
        o = urlparse(url)
        for s in self.scope:
            if o.netloc.endswith(s):
                return True
        return False
