import logging
from functools import wraps
from typing import Callable

logger = logging.getLogger()


def retry(f: Callable):
    times = 3

    @wraps(f)
    def _wrapper(*args, **kwargs):
        for _ in range(times - 1):
            try:
                return f(*args, **kwargs)
            except Exception as e:
                logger.debug(e)
        return f(*args, **kwargs)

    return _wrapper


def safe(f: Callable):
    @wraps(f)
    def _wrapper(*args, **kwargs):
        try:
            return f(*args, **kwargs)
        except Exception as e:
            logger.warning(e)
        return f(*args, **kwargs)

    return _wrapper
