from __future__ import print_function
import requests
import datetime


class Crt(object):
    base_url = ""
    token = ""

    def __init__(self, base_url, token):
        self.base_url = base_url
        self.token = token
        self.verify = "/etc/ssl/certs/ca-certificates.crt"

    def get_certificate(self, certificate_id):
        if not str(certificate_id).isdigit():
            return False

        payload = {"format": "json"}
        url = self.base_url + "/api/v2/certificate/{}/".format(str(certificate_id))
        headers = {"Authorization": "OAuth " + self.token}

        try:
            r = requests.get(url, params=payload, headers=headers, verify=self.verify)
            return r.json()
        except Exception:
            pass
        return {}

    def approve_request(self, request_id):
        if not str(request_id).isdigit():
            return False
        url = self.base_url + "/api/approve-request/{}/".format(str(request_id))
        headers = {"Authorization": "OAuth " + self.token}
        r = requests.put(
            url, headers=headers, json={"approved": True}, verify=self.verify
        )

        if r.status_code == 200:
            return True
        return False

    def reject_request(self, request_id):
        if not str(request_id).isdigit():
            return False
        url = self.base_url + "/api/approve-request/{}/".format(str(request_id))

        headers = {"Authorization": "OAuth " + self.token}
        r = requests.put(
            url, headers=headers, json={"approved": False}, verify=self.verify
        )

        if r.status_code == 200:
            return True
        return False

    def load_date(self, datestr):
        try:
            ts = datetime.datetime.strptime(datestr, "%Y-%m-%dT%H:%M:%S.%f+03:00")
        except Exception:
            ts = datetime.datetime.strptime(datestr, "%Y-%m-%dT%H:%M:%S+03:00")
        if ts:
            return ts
        return None
