import errno
import logging
import os


def _mkdir_p(path):
    try:
        os.makedirs(path)
    except OSError as exc:  # Python >2.5
        if exc.errno == errno.EEXIST and os.path.isdir(path):
            pass
        else:
            raise


def get_file_logger(log_name="default", log_folder="logs", log_level=logging.DEBUG):

    try:
        _mkdir_p(log_folder)
    except PermissionError:
        return None

    log_name_ = "seclib.{}".format(log_name)
    logger = logging.getLogger(log_name_)
    logger.setLevel(log_level)

    if not logger.handlers:
        fh = logging.FileHandler("{}/{}".format(log_folder, log_name))
        fh.setLevel(log_level)
        formatter = logging.Formatter(
            "%(asctime)s - %(name)s - %(levelname)s - %(message)s"
        )
        fh.setFormatter(formatter)
        logger.addHandler(fh)

    return logger
