from __future__ import print_function
import requests


class Molly(object):
    base_url = ""
    token = ""

    def __init__(self, base_url, token):
        self.base_url = base_url
        self.token = token

    def get_stat(self):
        payload = {"format": "json"}
        url = self.base_url + "/v1/stat/"
        headers = {"Authorization": "OAuth " + self.token}

        try:
            r = requests.get(
                url,
                params=payload,
                headers=headers,
                verify="/etc/ssl/certs/ca-certificates.crt",
            )
            result = r.json()
        except Exception:
            return {}

        return result

    def get_targets(self, filter_values=()):
        payload = {"format": "json"}

        if filter_values:
            payload[filter_values[0]] = filter_values[1]

        url = self.base_url + "/v1.1/targets/"
        headers = {"Authorization": "OAuth " + self.token}

        try:
            r = requests.get(
                url,
                params=payload,
                headers=headers,
                verify="/etc/ssl/certs/ca-certificates.crt",
            )
            json_data = r.json()
            result = json_data["targets"]
        except:
            return []

        return result

    def get_targets_by_startrek(self, st, only_one=False):
        result = self.get_targets(filter_values=("tracker_startrek", st))
        if only_one and result:
            return result[0]
        return result

    def init_scan(self, url, profile="Yandex", st_queue="", st_ticket="", abc_id=0):

        resp = dict()
        payload = {"target_uri": url, "profile": profile}

        if st_queue:
            payload["st_queue"] = st_queue

        if st_ticket:
            payload["st_ticket"] = st_ticket

        if abc_id:
            payload["abc_id"] = abc_id

        url = self.base_url + "/v1.1/scan/"
        headers = {"Authorization": "OAuth " + self.token}

        r = requests.post(
            url,
            headers=headers,
            verify="/etc/ssl/certs/ca-certificates.crt",
            data=payload,
        )
        if r.status_code == 200:
            resp = r.json()
            scan_ids = resp.get("scan_id", [])
            if scan_ids:
                scan_id = scan_ids.pop()
                return scan_id
        return False

    def fetch_scan_result(self, scan_id):
        url = self.base_url + "/v1.1/scan/"
        headers = {"Authorization": "OAuth " + self.token}
        r = requests.get(
            url + str(scan_id),
            headers=headers,
            verify="/etc/ssl/certs/ca-certificates.crt",
        )

        if r.status_code == 200:
            resp = r.json()
            if resp.get("status", "") != "in_progress":
                return resp
            else:
                print(resp)
        return None
