# -*- encoding: utf-8 -*-
import requests


class Puncher(object):
    base_url = ""
    token = ""

    def __init__(self, base_url, token):
        self.base_url = base_url.strip()
        self.token = token.strip()
        self.base_headers = {
            "content-type": "application/json",
            "Authorization": "OAuth " + self.token,
        }

    def get_rules_in_status(self, limit=None, status=None):
        result = []
        payload = {}
        if status:
            payload["status"] = status
        next_url = self.base_url + "requests"
        while next_url:
            r = requests.get(next_url, params=payload, headers=self.base_headers)
            json_data = r.json()
            result.extend(json_data.get("requests", []))
            next_url = json_data["links"].get("next")
        return result

    def approve_rule(self, id_rule=None):
        url = self.base_url + "requests/" + id_rule + "/approve"
        requests.post(url, headers=self.base_headers)

    def reject_rule(self, id_rule=None):
        url = self.base_url + "requests/" + id_rule + "/reject"
        requests.post(url, headers=self.base_headers)

    def get_rule(self, id_rule=None):
        url = self.base_url + "requests"
        r = requests.get(url, headers=self.base_headers, params={"id": id_rule})
        json_data = r.json()
        if not json_data.get("requests", []):
            return {}
        return json_data.get("requests", [])[0]

    # def get_rules_by_login(self, login, destination=None, status='active'):
    #     """
    #             Get all rules from puncher where %login% in source.

    #             :param login: Group url name (for example: yandex_mnt_security)
    #             :type login: str
    #             :param destination: Optional param for chosing exact destination. accept  fqdn/macros/c_group, without protocol
    #             :type destination: str
    #             :param status: default is active - so, in result u will get only acive rules.
    #              U can choose statuses from: new, confirmed, approved, closed_by_author, closed_by_admin, closed_by_security
    #               or None(for geting all rules)
    #             :return: dict with all rules from login and groups
    #             :rtype: dict
    #             """
    #     payload['source'] = '%' + login + '%'
    #     if destination:
    #         payload['destination'] = destination
    #     if status:
    #         payload['status']=status
    #     url = self.base_url + 'rules'
    #     r = requests.get(url, params=payload, headers=self.base_headers)
    #     json_data = r.json()
    #     rules = json_data['rules']
    #     while json_data.get('links') and json_data['links'].get('next') is not None:
    #         url = json_data['links']['next']
    #         r = requests.get(url, params=payload, headers=base_headers)
    #         json_data = r.json()
    #         rules = rules + json_data['rules']
    #     return rules

    @staticmethod
    def port_parse(port):
        result = []
        for part in port.split(","):
            if "-" in part:
                a, b = part.split("-")
                a, b = int(a), int(b)
                result.extend(range(a, b + 1))
            else:
                a = int(part)
                result.append(a)
        return result

    def get_exact_rules(
        self, port, status="active", source=None, destination=None, protocol="tcp"
    ):
        payload = {}
        url = self.base_url + "rules"
        payload["status"] = status
        if source:
            payload["source"] = source
        if destination:
            payload["destination"] = destination
        if port:
            payload["ports"] = port
        if protocol:
            payload["protocol"] = protocol

        payload["sort"] = "source"
        r = requests.get(url, params=payload, headers=self.base_headers)
        json_data = r.json()
        rules = json_data["rules"]
        while (json_data.get("links")) and (json_data["links"].get("next") is not None):
            url = json_data["links"]["next"]
            r = requests.get(url, headers=self.base_headers)
            json_data = r.json()
            rules.append(rules)
        return rules
