import json

import requests
from requests.auth import HTTPBasicAuth


class Sender(object):
    base_url = ""
    token = ""

    def __init__(self, base_url, token, account_slug):
        self.base_url = base_url.strip()
        self.token = token.strip()
        self.account_slug = account_slug.strip()

    def send(self, campaign_slug, to_email, args={}):
        payload = {"async": "false"}
        params = {"to_email": to_email}

        if args:
            payload["args"] = json.dumps(args)

        url = "%s/%s/transactional/%s/send" % (
            self.base_url,
            self.account_slug,
            campaign_slug,
        )
        r = requests.post(
            url, params=params, data=payload, auth=HTTPBasicAuth(self.token, "")
        )
        if r.status_code == 200:
            return True
        else:
            return False
