import requests
import json

import datetime


class StatSender(object):
    def __init__(self, stat_user, stat_passwd, api_url):
        self.api_url = api_url
        self.stat_user = stat_user
        self.stat_passwd = stat_passwd

    def dictify(self, obj):
        keys = [field for field in dir(obj) if not callable(getattr(obj, field))]
        result = {}
        for key in keys:
            result[key] = getattr(obj, key)
        return result

    def post_to_stat(
        self, data, name, scale="d", beta=False, _append_mode=1, date=None
    ):
        if not date:
            date = datetime.date.today().isoformat()
        buf = {"fielddate": date}
        buf.update(data)
        r = requests.post(
            self.api_url,
            headers={
                "StatRobotUser": self.stat_user,
                "StatRobotPassword": self.stat_passwd,
            },
            data={
                "name": name,
                "scale": scale,
                "json_data": json.dumps({"values": [(buf)]}),
                "_append_mode": _append_mode,
            },
            verify="/etc/ssl/certs/ca-certificates.crt",
        )

        return r
