import tvmauth


class TVM(object):
    def __init__(self, client_id, client_secret, destinations):
        destinations = {str(dst): int(dst) for dst in destinations}
        self.tvm2_client = tvmauth.TvmClient(
            tvmauth.TvmApiClientSettings(
                self_tvm_id=int(client_id),
                self_secret=client_secret,
                dsts=destinations,
            )
        )

    def get_service_ticket(self, dst_id):
        return self.tvm2_client.get_service_ticket_for(str(dst_id))

    def stop(self):
        self.tvm2_client.stop()
