import requests
import json
import copy


class Wiki(object):
    """docstring for Wiki"""

    def __init__(self, base_url, token):
        self.base_url = self.check_link(base_url)
        self.headers = {
            "Authorization": "OAuth %s" % token,
            "Content-Type": "application/json",
        }

    def write_page(self, url, title, text):

        data = {"title": title, "body": text}
        url = "%s%s" % (self.base_url, self.check_link(url))
        request = requests.post(url, headers=self.headers, data=json.dumps(data))
        return request

    def read_grid(self, url):
        url = "%s%s/.grid" % (self.base_url, self.check_link(url))
        resp = requests.get(url, headers=self.headers, allow_redirects=False)
        data = resp.json()
        return data

    def create_grid(self, title, url):
        # create empty grid
        url = "%s%s" % (self.base_url, self.check_link(url))
        resp = requests.post(
            "%s/.grid/create" % (url),
            headers=self.headers,
            json={"title": title},
            allow_redirects=False,
        )
        data = resp.json()
        return data

    def set_grid(self, layout, url):
        # create grid structure
        grid_structure_json = {"version": 100, "changes": layout}
        url = "%s%s/.grid/change_and_get_document" % (
            self.base_url,
            self.check_link(url),
        )
        resp = requests.post(
            url, headers=self.headers, json=grid_structure_json, allow_redirects=False
        )
        data = resp.json()
        return data

    def modify_grid(self, data, filling, url):
        structure = data["data"]["grid"]["structure"]["fields"]
        columns = []
        for column in structure:
            columns.append(column["name"])

        changes_dict = {"added_row": {"after_id": "-1", "before_id": "-1", "data": {}}}
        changes = []
        for fill in filling:
            buff = copy.deepcopy(changes_dict)
            for i, filler in enumerate(fill):
                buff["added_row"]["data"][columns[i]] = filler
            changes.append(buff)
        # fill data
        grid_data_json = {
            "changes": changes,
            "version": data["data"]["grid"]["version"],
        }
        url = "%s%s/.grid/change_and_get_document" % (self.base_url, url)
        resp = requests.post(
            url, headers=self.headers, json=grid_data_json, allow_redirects=False
        )
        data = resp.json()
        return data

    def make_a_grid(self, title, layout, filling, url):
        self.create_grid(title=title, url=url)
        data = self.set_grid(layout=layout, url=url)
        return self.modify_grid(data=data, filling=filling, url=url)

    def check_link(self, link):
        if link.startswith("/"):
            link = link[1:]
        return link if link.endswith("/") else "%s%s" % (link, "/")
