import re
from security.yodax.lib.gixy.formatters.base import BaseFormatter as GBaseFormatter


class BaseFormatter(GBaseFormatter):
    def __init__(self, gixy_formatter):
        super(BaseFormatter, self).__init__()
        self.formatter = gixy_formatter()

    def format_reports(self, reports, stats):
        oss_reports_to_ya(reports)
        return self.formatter.format_reports(reports=reports, stats=stats)


def oss_help_to_ya(help_url):
    return re.sub('^https://github.com/yandex/gixy/blob/master/docs/(?:ru|en)/plugins/([^.]+?)\.md$',
                  'https://wiki.yandex-team.ru/product-security/yodax/\\1/',
                  help_url)


def oss_reports_to_ya(reports):
    for _, issues in reports.items():
        for issue in issues:
            issue['help_url'] = oss_help_to_ya(issue['help_url'])

