from security.yodax.lib.formatters.base import BaseFormatter
from security.yodax.lib.gixy.formatters.base import BaseFormatter as GBaseFormatter
from security.yodax.lib.formatters.yodax_out import yodax_out_pb2 as yodax_out
from security.yodax.lib.gixy.core import severity


class ProtoFormatter(BaseFormatter):
    def __init__(self):
        super(ProtoFormatter, self).__init__(ProtoFormatterImpl)


class ProtoFormatterImpl(GBaseFormatter):
    def __init__(self):
        super(ProtoFormatterImpl, self).__init__()

    def format_reports(self, reports, stats):
        result = yodax_out.Result()
        for path, issues in reports.items():
            for yodax_issue in issues:
                issue = result.issues.add()
                issue.path = path
                issue.plugin = yodax_issue['plugin']
                issue.summary = yodax_issue['summary']
                issue.severity = _severity_to_proto(yodax_issue['severity'])
                issue.description = yodax_issue['description']
                issue.reference = yodax_issue['help_url']
                issue.reason = yodax_issue['reason']
                issue.config = yodax_issue['config']

        return result.SerializeToString()

def _severity_to_proto(yodax_severity):
    if yodax_severity == severity.LOW:
        return yodax_out.S_LOW
    elif yodax_severity == severity.MEDIUM:
        return yodax_out.S_MEDIUM
    elif yodax_severity == severity.HIGH:
        return yodax_out.S_HIGH
    else:
        return yodax_out.S_UNSPECIFIED