import security.yodax.lib.gixy
from security.yodax.lib.gixy.plugins import get_all


class PluginsManager(object):
    def __init__(self, config=None):
        self.config = config
        self._plugins = []

    def init_plugins(self):
        exclude = self.config.skips if self.config else None
        include = self.config.plugins if self.config else None
        severity = self.config.severity if self.config else None
        for plugin_cls in get_all():
            name = plugin_cls.__name__
            if include and name not in include:
                # Skip not needed plugins
                continue
            if exclude and name in exclude:
                # Skipped plugins
                continue
            if severity and not security.yodax.lib.gixy.severity.is_acceptable(plugin_cls.severity, severity):
                # Skip plugin by severity level
                continue
            if self.config and self.config.has_for(name):
                options = self.config.get_for(name)
            else:
                options = plugin_cls.options
            self._plugins.append(plugin_cls(options))

    @property
    def plugins(self):
        if not self._plugins:
            self.init_plugins()
        return self._plugins

    @property
    def plugins_classes(self):
        return get_all()

    def get_plugins_descriptions(self):
        return map(lambda a: a.name, self.plugins)

    def audit(self, directive):
        for plugin in self.plugins:
            if plugin.directives and directive.name not in plugin.directives:
                continue
            plugin.audit(directive)

    def issues(self):
        result = []
        for plugin in self.plugins:
            if not plugin.issues:
                continue
            result.extend(plugin.issues)
        return result
