from logging.handlers import BufferingHandler

class LogHandler(BufferingHandler):
    def __init__(self):
        # BufferingHandler takes a "capacity" argument
        # so as to know when to flush. As we're overriding
        # shouldFlush anyway, we can set a capacity of zero.
        # You can call flush() manually to clear out the
        # buffer.
        super(LogHandler, self).__init__(0)

    def shouldFlush(self, **kwargs):
        return False

    def emit(self, record):
        self.buffer.append(record.__dict__)

    def flush(self):
        self.acquire()
        result = []
        try:
            result = self.buffer
            self.buffer = []
        finally:
            self.release()
        return result