$(document).ready(function() {
  'use strict';

  function panelTypeBySeverity(severity) {
    switch (severity) {
      case 'LOW':
        return 'panel-info'
      case 'MEDIUM':
        return 'panel-warning'
      case 'HIGH':
        return 'panel-danger'
      default:
        return 'panel-default'
    }
  }

  function severityOrder(severity) {
    switch (severity) {
      case 'LOW':
        return 2;
      case 'MEDIUM':
        return 1;
      case 'HIGH':
        return 0;
      default:
        return 3;
    }
  }

  function processResults(problemTemplate, resultTemplate, data) {
    $('#process-button').button('reset');
    let results = $('#results');
    results.empty();

    if (data.warnings) {
      data.warnings.forEach(function(warning) {
        console.log(`Warning [${warning.name}]: ${warning.message}`);
      });
    }

    if (!data.status) {
      results.append(resultTemplate({
        'type': 'failed',
        'title': 'Shit happens!',
        'message': 'Something went wrong'
      }));
    } else if (data.status === 'failed') {
      results.append(resultTemplate({
        'type': 'failed',
        'title': 'Shit happens!',
        'message': data.error
      }));
    } else if (!data.result.length) {
      results.append(resultTemplate({
        'type': 'success',
        'title': 'Congratulations!',
        'message': 'No issues found. You rock! \uD83D\uDE0E'
      }));
    } else {
      let sorted = data.result.sort((a, b) => {
        return severityOrder(a.severity) - severityOrder(b.severity)
      });
      sorted.map(function(res) {
        results.append(problemTemplate({
          'panel_type': panelTypeBySeverity(res.severity),
          'summary': res.summary,
          'severity': res.severity[0].toUpperCase() + res.severity.slice(1).toLowerCase(),
          'description': res.description,
          'config': res.config,
          'reference': res.reference,
          'recommendation': res.recommendation,
          'reason': res.reason
        }));
      });
    }

    $("html, body").animate({scrollTop: results.offset().top}, 500);
  }

  function submitForm(form, next) {
    $('#results').empty();
    $('#process-button').button('loading');

    let request = $.ajax({
      type: 'POST',
      url: form.attr('action'),
      contentType: 'application/json; charset=utf-8',
      dataType: 'json',
      data: JSON.stringify(form.serializeArray().reduce(function(storage, item) {
        storage[item.name] = item.value;
        return storage;
      }, {}))
    })
      .done(next);

    return false;
  }


  let problemTemplate = _.template($('#problem-template').html());
  let resultTemplate = _.template($('#result-template').html());

  let editor = CodeMirror.fromTextArea(document.getElementById('code'), {
    autofocus: true
  });
  let form = $('#configurator');
  form.on("submit", submitForm.bind(null, form, processResults.bind(null, problemTemplate, resultTemplate)));
});
