import sys
import uuid
import json
import decimal
import logging
import datetime
import logging
import nirvana.job_context as nv

from yql.api.v1.client import YqlClient
from security.yql_conversion import main
from yql.client.parameter_value_builder import \
    YqlParameterValueBuilder as ValueBuilder

logger = logging.getLogger(__name__)

ctx = nv.context()
params = ctx.get_parameters()
inputs = ctx.get_inputs()
outputs = ctx.get_outputs()

if __name__ == "__main__":

    log_level = logging.INFO
    if params.get("debug_log_level") == (None or True):
        # NIRVANA-14734
        log_level = logging.DEBUG

    logging.basicConfig(level=log_level,
                        format='%(asctime)s - %(levelname)s - %(message)s',
                        stream=sys.stdout)

    logger.info("Starting processing...")

    if inputs.has("file_with_parameters"):
        json_parameters = open(inputs.get("file_with_parameters")).read()
        json_parameters = json.loads(json_parameters)
        logger.debug("Parameters:\n {}".format(json_parameters))
    else:
        raise RuntimeError("File with parameters hasn't found.")

    if "query" in params:
        query = params.get('query')
        query = query.format(json_parameters.get('$row'))
        logger.info("Query:\n {}".format(query))
    else:
        raise NameError("Query string hasn't found.")

    token = params.get('yql_token')

    parameters = main(query, json_parameters)
    with YqlClient(token=token) as yql_client:
        request = yql_client.query(query, syntax_version=1)
        request.run(parameters=parameters)
        result = request.get_results()

        if request.exit_code:
            raise NameError(
                "Operation failed with exit code {}".format(request.exit_code))

    request_info = json.dumps(request.json)
    logger.info("YQL request info:\n {}".format(request_info))

    if params.get("fill-up-output") == (None or True):
        # NIRVANA-14734
        final_json = json.dumps(result.json)

        with open(outputs.get('file_with_result'), 'w') as file:
            file.write(final_json)

    logger.info("End Main")
