import six

from cpython cimport PyBytes_AS_STRING
from util.generic.string cimport TString
from util.generic.hash cimport THashMap
from util.generic.vector cimport TVector
from util.generic.ptr cimport THolder


cdef extern from "security/yql_sec_cube/declminer/type_parser.h" namespace "NDeclMiner":
    cpdef enum EKind:   
        KIND_NONE = 0
        KIND_PRIMITIVE = 1
        KIND_OPTIONAL = 2
        KIND_LIST = 100
        KIND_DICT = 101
        KIND_TUPLE = 102
        KIND_STRUCT = 103
        KIND_VARIANT = 104
        KIND_VOID = 200
        KIND_NULL = 201
        KIND_EMPTY_LIST = 202
        KIND_EMPTY_DICT = 203
        KIND_ID = 300
        KIND_KEY_VALUE = 301

    cdef cppclass TDataType:
        EKind Kind
        TString Value
        TVector[TDataType] Childs


cdef extern from "security/yql_sec_cube/declminer/extractor.h" namespace "NDeclMiner":
    cdef cppclass TQuery:
        @staticmethod
        THolder[TQuery] Parse(const TString &query, const TString &queryName)
        
        THashMap[TString, TDataType] ResolveDeclares()

cdef object _tdatatype_to_py(TDataType data):
    # Add parsed ast like structure to big dict
    result = {
        "kind": EKind(data.Kind),
        "value": data.Value.c_str().decode(),
        "childs": []
    }

    cdef TDataType child
    for child in data.Childs:
        result["childs"].append(_tdatatype_to_py(child))

    return result

cdef class Parser(object):

    def parse(self, str query):
        # Using python binding to YQL lexer
        query_string = TString(PyBytes_AS_STRING(six.ensure_binary(query)))
        try:
            parsed_query = TQuery.Parse(query_string, "yql")
        except Exception as e:
            print(e) # ??
            raise Exception
        
        resolved_declares = parsed_query.Get().ResolveDeclares()
        result = dict()

        for pair in resolved_declares:
            key = pair.first.c_str().decode()
            value = pair.second
            result[key] = _tdatatype_to_py(value)
        return result
