#pragma once

#include <util/generic/maybe.h>
#include <type_traits>

namespace NDeclMiner {

    class TError: public yexception {
    };

    template <class E, class T>
    static inline TError&& operator<<(TError& e, const T& t) {
        e.Append(t);

        return std::forward<E>(e);
    }

    struct TVoid {
    };

    template<class T>
    using TResult = std::variant<T, TError>;

    template<class T>
    bool IsError(const TResult<T>& res) {
        return std::holds_alternative<TError>(res);
    }

    template <class T>
    TMaybe<TError> GetError(const TResult<T>& res) {
        if (const auto* err = std::get_if<TError>(&res)) {
            return *err;
        }
        return Nothing();
    }
}

template<>
inline void Out<NDeclMiner::TError>(IOutputStream &out, const NDeclMiner::TError& error) {
    out << error.AsStrBuf();
}
