#include <security/yql_sec_cube/declminer/extractor.h>
#include <util/string/builder.h>

namespace {
    void printTyp(const NDeclMiner::TDataType &typ, const TString &padding) {
        Cout << padding << typ.Kind;
        if (!typ.Value.empty()) {
            Cout << "[" << typ.Value << "]";
        }

        if (typ.Childs.empty()) {
            Cout << Endl;
            return;
        }

        Cout << Endl;
        for (const auto &child: typ.Childs) {
            printTyp(child, padding + "  ");
        }
    }

    void PrintDecl(const TString &key, const NDeclMiner::TDataType &typ) {
        Cout << Endl;
        Cout << "Name: " << key << ":" << Endl;
        Cout << "Type: " << Endl;
        printTyp(typ, "  ");
    }
}

int main() {
    auto sql = Cin.ReadAll();
    auto query = NDeclMiner::TQuery::Parse(sql, "stdin");
    const auto declares = query->ResolveDeclares();

    Cout << "Declares: " << Endl;
    for (const auto&[key, typ]: declares) {
        PrintDecl(key, typ);
    }
}