#pragma once

#include "error.h"
#include "type_parser.h"

#include <ydb/library/yql/parser/lexer_common/lexer.h>
#include <util/generic/hash.h>

namespace NDeclMiner {
    class TQuery {
    public:
        static THolder<TQuery> Parse(const TString &query, const TString &queryName = {});

        THashMap<TString, TDataType> ResolveDeclares();

    private:
        const TString originalQuery;
        NSQLTranslation::TParsedTokenList tokens;

    private:
        TQuery(TString query, NSQLTranslation::TParsedTokenList tokens)
                : originalQuery{std::move(query)}, tokens(std::move(tokens)) {
        }
    };
}
