#pragma once

#include "error.h"
#include <ydb/library/yql/ast/yql_ast.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NDeclMiner {

    enum EKind {
        KIND_NONE = 0,
        KIND_PRIMITIVE = 1,
        KIND_OPTIONAL = 2,

        // containers
        KIND_LIST = 100,
        KIND_DICT = 101,
        KIND_TUPLE = 102,
        KIND_STRUCT = 103,
        KIND_VARIANT = 104,

        // special
        KIND_VOID = 200,
        KIND_NULL = 201,
        KIND_EMPTY_LIST = 202,
        KIND_EMPTY_DICT = 203,

        // DeclMiner-specific
        KIND_ID = 300,
        KIND_KEY_VALUE = 301,
    };

    struct TDataType {
        EKind Kind;
        TString Value;
        TVector<TDataType> Childs;
    };

    TResult<TDataType> ParseDataType(const NYql::TAstNode *node);

    void DebugPrintNode(const NYql::TAstNode *node, const TString &lvl);
}
