package main

import (
	"net/http"
	"os"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/httputil/middleware/recovery"
)

var (
	pongReply = []byte("pong")
)

func main() {
	targetURI := os.Getenv("TARGET_URI")
	if targetURI == "" {
		panic("empty ENV[TARGET_URI]")
	}

	logger, err := zap.NewQloudLogger(log.InfoLevel)
	if err != nil {
		panic(err)
	}

	r := chi.NewRouter()
	r.Use(recovery.New(recovery.WithLogger(logger)))

	r.Get("/ping", func(w http.ResponseWriter, r *http.Request) {
		_, _ = w.Write(pongReply)
	})

	r.Get("/", func(w http.ResponseWriter, r *http.Request) {
		http.Redirect(w, r, targetURI, http.StatusFound)
	})

	if err := http.ListenAndServe(":80", r); err != nil {
		panic(err)
	}
}
