from __future__ import absolute_import

from . import rpc


class IBetaDescriptor(object):
    def __init__(self, params, mngr):
        self.params = params
        self.mngr = mngr

    def id(self):
        return self.params['id']

    def name(self):
        return self.params['beta']

    def started(self):
        if 'started' in self.params:
            return self.params['started']

        return False

    def start(self):
        return self.mngr.start(self.id())

    def stop(self):
        return self.mngr.stop(self.id())

    def __str__(self):
        return "id = " + str(self.id()) + ", name = " + str(self.name()) + ", started = " + str(self.started())


class IBetas(object):
    CMS_BETAS = rpc('betaconf', protocol='xmlrpc')

    def listBetas(self):
        return [IBetaDescriptor(x, self) for x in self.CMS_BETAS.listBetas()]

    def start(self, id):
        return self.CMS_BETAS.start(id)

    def stop(self, id):
        return self.CMS_BETAS.stop(id)

    def findByName(self, name):
        for beta in self.listBetas():
            if beta.name() == name:
                return beta

        raise Exception('no beta with name ' + name)


def Manager():
    return IBetas()
