import unittest

from api.cms.registry import Registry


class RegistryTest(unittest.TestCase):
    def test1PriemkaCorrectnes(self):
        prodwsHosts = set((i.host for i in Registry.listSearchInstances("HEAD", instanceTagName="prodws-production")))
        priemkaHosts = set(
            (i.host for i in Registry.listSearchInstances("HEAD", instanceTagName="priemka-production"))
        )
        priemkaReplicaHosts = set(
            (i.host for i in Registry.listSearchInstances("HEAD", instanceTagName="priemka-production-replica"))
        )
        testwsHosts = set((i.host for i in Registry.listSearchInstances("HEAD", instanceTagName="testws-production")))
        #test priemka replica existance
        self.assertTrue(priemkaReplicaHosts)
        #test no intersection with production
        self.assertEquals(priemkaHosts & prodwsHosts, set())
        #test no intersection with testws
        self.assertEquals(priemkaHosts & testwsHosts, set())
        #test that replica belongs to all hosts
        self.assertEquals(priemkaReplicaHosts - priemkaHosts, set())

    def testHasHeadConf(self):
        confs = Registry.listConf()
        self.assertTrue('HEAD' in confs)
        self.assertFalse(confs["HEAD"].is_frozen)

    def testShardTags(self):
        shardTags = [t.name for t in Registry.listAllShardTags(conf="HEAD")]
        for tag in ("RusTier0", "EngTier0"):
            self.assertTrue(tag in shardTags)

    def testInstanceTags(self):
        instanceTags = [t.name for t in Registry.listAllSearchInstanceTags("HEAD")]
        for tag in ("testws-production", "priemka-production"):
            self.assertTrue(tag in instanceTags)

    def testListSearchInstances(self):
        self.assertTrue(Registry.listSearchInstances("HEAD", shardTagName="diversity"))
        self.assertTrue(
            Registry.listSearchInstances("HEAD", shardTagName="foreign", instanceTagName="testws-production")
        )

    def testNewStyleUpload(self):
        self.assertTrue(Registry.listSearchInstances("HEAD", instanceTagName="newstyle_upload"))

    def testListSearchHosts(self):
        self.assertTrue(list(
            Registry.listSearchHosts("HEAD", shardTagName="foreign", instanceTagName="testws-production")
        ))

#    def testMultiTagList(self):
#        self.assertTrue(list(Registry.listSearchInstances("HEAD", instanceTagName=["production", "newstyle_upload"])))


if __name__ == "__main__":
    unittest.main()
