from six.moves import BaseHTTPServer as BH
try:
    __import__('pkg_resources').require('requests', 'unittest2')
except Exception:
    pass
try:
    import unittest2 as unittest
except ImportError:
    import unittest
import requests
import threading
import socket
import time
import api.conductor as C


class SluggishHandler(BH.BaseHTTPRequestHandler):
    def do_GET(self):
        time.sleep(self.server.delay)
        try:
            self.send_response(200)
        except:
            pass


class HttpErrorHandler(BH.BaseHTTPRequestHandler):
    def do_GET(self):
        try:
            self.send_error(self.server.code_to_send, self.server.text_to_send)
        except:
            pass


class HttpErrorServer(object):
    def __init__(self, port):
        self.server = BH.HTTPServer(('', port), HttpErrorHandler)
        self.server.code_to_send = 404
        self.server.text_to_send = ""
        threading.Thread(target=self.run).start()

    def run(self):
        try:
            self.server.serve_forever()
        except:
            pass

    def stop(self):
        self.server.shutdown()

    def set_error(self, code, text):
        self.server.code_to_send = code
        self.server.text_to_send = text


class SluggishServer(object):
    def __init__(self, delay, port):
        self.server = BH.HTTPServer(('', port), SluggishHandler)
        self.server.delay = delay
        threading.Thread(target=self.run).start()

    def run(self):
        try:
            self.server.serve_forever()
        except:
            pass

    def stop(self):
        self.server.shutdown()


class TestRequestsTimeout(unittest.TestCase):
    def create_server(self, delay):
        port = 8000
        while port < 65536:
            try:
                print('trying port {0}'.format(port))
                s = SluggishServer(delay, port)
                return s, port
            except socket.error as e:
                port += 1
        raise Exception("No ports available")

    def get(self, port, timeout):
        return requests.get('http://localhost:{0}/'.format(port), timeout=timeout)

    def test_timeout(self):
        s, port = self.create_server(0.1)
        try:
            self.assertRaises(requests.exceptions.Timeout, self.get, port, 0.05)
        finally:
            s.stop()

    def test_good(self):
        s, port = self.create_server(0.1)
        try:
            r = self.get(port, 0.2)
            self.assertEqual(r.status_code, 200)
        finally:
            s.stop()


class TestConductorAccessible(unittest.TestCase):
    def setUp(self):
        self.conductor = C.Conductor()

    def tearDown(self):
        self.conductor = None

    def test_cmsearch(self):
        hosts = self.conductor.hosts('cmsearch')
        self.assertTrue('cmsearch' in ' '.join(hosts))


class TestHttpErrors(unittest.TestCase):
    def create_server(self):
        port = 8000
        while port < 65536:
            try:
                print('trying port {0}'.format(port))
                s = HttpErrorServer(port)
                return s, port
            except socket.error as e:
                port += 1
        raise Exception("No ports available")

    def test_404(self):
        s, port = self.create_server()
        s.set_error(404, "")
        c = C.Conductor('http://localhost:{0}/{{0}}'.format(port))
        try:
            with self.assertRaises(C.ConductorGroupNotFoundError):
                c.hosts("")
        finally:
            s.stop()

    def test_non_404(self):
        s, port = self.create_server()
        s.set_error(408, "abracadabra")
        c = C.Conductor('http://localhost:{0}/{{0}}'.format(port))
        try:
            with self.assertRaises(C.ConductorHttpError) as cm:
                c.hosts("")
            self.assertEquals(cm.exception.code, 408)
            # when r.reason available in requests, change "" to "abracadabra"
            self.assertEquals(cm.exception.reason, "")
        finally:
            s.stop()


if __name__ == '__main__':
    unittest.main()
