from kernel.util.errors import SkynetBaseError


__all__ = [
    'CopierError', 'ApiError', 'ApiConnectionError', 'FilesystemError', 'Timeout',
    'ResourceError', 'ResourceNotAvailable', 'ResourceNotAllowedByNetwork', 'ResourceDownloadError'
]


class CopierError(SkynetBaseError):
    """ Base class for all copier errors. """
    def __init__(self, message=None):
        SkynetBaseError.__init__(self, message=message)


class ApiError(CopierError):
    """ Indicates probably invalid API usage. """


class ApiConnectionError(ApiError):
    """ Indicates that where was an error during API <-> Server connection. """


class FilesystemError(CopierError, IOError):
    """ All exception related to filesystem (files, paths, etc.). """


class Timeout(CopierError):
    """ This will indicate that timeout occurs on some operations. """


class UnshareableResource(CopierError):
    """ Indicates that copier cant make resource with specified files by some reason. """


class ResourceError(CopierError):
    """ All errors related to resources. """


class ResourceNotAvailable(ResourceError):
    """ If no servers share resource info on network. """


class ResourceNotAllowedByNetwork(ResourceError):
    """ If where are some seeders, but they dont have network we need (e.g. fastbone). """


class ResourceDownloadError(ResourceError):
    """ Error which indicates that some errors occurred during resource download. """


# Obsolete errors, never raised

class NotRegisteredJob(CopierError):
    """ Server has no info about job asked (probably restart occured). """
