# -*- coding: utf-8 -*-

"""
Public cqudp API
=================

cqudp - service which allows you to run python code on group of remote hosts (Maybe single host).
cqudp consists of two parts:
 1. Server which executes your code.
 2. Api to this server.
    Which allows you to write transparent code that runs on several ( Tested on 20k+ :) ) hosts.

Example of getting loadavg from remote hosts::

    import os
    from api.cqueue import Client
    from library.sky.hostresolver import Resolver

    if __name__ == '__main__':
        for host, ncpu, err in Client.run(Resolver().resolveHosts(['i+testws']), os.loadavg)
            if err:
                print host, 'Error: {0}'.format(err)
            else:
                print host, ncpu
"""

__all__ = [
    'Client',
    'CQWarning',
    'RemoteLogHandler',
    'IRemoteObject',
    'Full',
    'Empty',
    'Timeout',
]

from .client import Client, CQWarning
from .log import RemoteLogHandler
from .remoteobject import IRemoteObject
from .primitives import Full, Empty, Timeout
