# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import os
import pwd


class Task(object):
    osUser = os.getlogin()  # здесь может быть, например, имя роботного пользователя
    sessionTimeout = 100

    def __call__(self):
        return pwd.getpwuid(os.getuid()).pw_name


def main():
    with Client() as client:
        with client.run(['localhost', 'host1', 'host2'], Task()) as session:
            for host, result, err in session.wait():
                if err is not None:
                    print(host, err)
                if result is not None:
                    assert result == Task.osUser, "Login mismatch"


if __name__ == '__main__':
    main()
