# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import os
import pwd


class Task(object):
    def __init__(self, login=None, session_timeout=100):
        self.osUser = login
        self.sessionTimeout = session_timeout

    def __call__(self):
        return pwd.getpwuid(os.getuid()).pw_name


def main():
    with Client() as client:
        task = Task(os.getlogin())  # можно передать произвольный логин, например, робота
        with client.run(['localhost', 'host1', 'host2'], task) as session:
            for host, result, err in session.wait():
                if err is not None:
                    print(host, err)
                if result is not None:
                    assert result == task.osUser, "Login mismatch"


if __name__ == '__main__':
    main()
