# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client


class MyTask(object):
    def __init__(self):
        self.potentially_used_param = 42

    def __call__(self):
        for i in ["Imagine", "there's", "no", "Heaven"]:
            yield i


def main():
    with Client() as client:
        hosts = ['localhost', 'host1', 'host2']
        task = MyTask()

        with client.iter(hosts, task) as session:
            for host, result, err in session.wait():
                print("Получен результат от %r: %s" % (host, (result, err)))


if __name__ == '__main__':
    main()
