# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client


def wait_for_results(session, results_expected):
    received = 0
    while received < results_expected:
        for host, result, err in session.poll(0):
            received += 1
            print("Получен результат №%d: %s" % (received, (host, result, err)))


class MyTask(object):
    param1 = 42

    def __init__(self, param2):
        self.__param2 = param2

    def __call__(self):
        return self.param1 / self.__param2


def main():
    with Client() as client:
        hosts = ['localhost', 'host1', 'host2']
        task = MyTask(6)

        with client.run(hosts, task) as session:
            # код ``wait_for_results`` приведён выше и повторять его не будем
            wait_for_results(session, len(hosts))


if __name__ == '__main__':
    main()
