# -*- coding: utf-8 -*-
from __future__ import print_function
# В этом модуле содержится stderr
import sys
# В этом модуле содержится getloadavg
import os

# Основная точка входа в cqueue
from api.cqueue import Client

# Библиотека для получения списков машин в Яндексе.
from library.sky.hostresolver import Resolver


def main():
    # Для начала нам нужно создать клиента:
    with Client() as cqueue:
        # И получить список машин с которых мы будеп получать загрузку.
        hosts = Resolver().resolveHosts('I@testws')  # Примерно 1500 машин тестового кластера.

        with cqueue.run(  # Просим запустить ...
            hosts,  # ... на выбраном списке машин ...
            os.getloadavg  # ... функцию, возвращаюшую загрузку системы.
        ) as session:
            # В этот момент исполнение уже началось.

            # Нам осталось только получить результаты и ошибки, если они произошли:
            for host, result, err in session.wait():
                if err:
                    # Ошибки могут возникнуть почти любые ...
                    # Сетевые, операционной системы, в конце концов функция getloadavg может бросить исключение ...
                    print('Error on {0}: `{1}`'.format(host, err), file=sys.stderr)
                else:
                    # Но если ошибки нет - мы получим результат:
                    print('{0:<10} {1}'.format(host, result))

# Хорошим тоном в Питоне считается писать такую конструкцию, в модулях которые предполагают непосредственный запуск.
# Кроме всего прочего, отсутствие такой проверки, при распределенном исполнение, может привести к бесконечному циклу.
# Эта проблема подробно описана в документации на cqudp под заголовком «Взрыв кластера».
if __name__ == '__main__':
    main()
