# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import os
import pwd


def my_task():
    return pwd.getpwuid(os.getuid()).pw_name


my_task.osUser = os.getlogin()  # здесь может быть, например, имя роботного пользователя
my_task.sessionTimeout = 100


def main():
    with Client() as client:
        with client.run(['localhost', 'host1', 'host2'], my_task) as session:
            for host, result, err in session.wait():
                if err is not None:
                    print(host, err)
                if result is not None:
                    assert result == my_task.osUser, "Login mismatch"


if __name__ == '__main__':
    main()
