# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import time


def my_task():
    for i in range(5):
        time.sleep(i)
        yield i


def main():
    with Client() as client:
        hosts = ['localhost', 'host1', 'host2']

        with client.iter(hosts, my_task) as session:
            for host, result, err in session.wait():
                print("Получен результат от %r: %s" % (host, (result, err)))


if __name__ == '__main__':
    main()
