# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
from api.cqueue.log import RemoteLogHandler
from kernel.util import logging


def some_long_task():
    # Настраиваем лог на удалённой стороне для отправки сообщений
    log = logging.getLogger('ya.fml.services.custom-task')
    # Выставляем уровень детализации всего лога (по умолчанию это WARNING)
    log.setLevel(logging.DEBUG)
    # И добавляем специальный обработчик
    log.addHandler(RemoteLogHandler())
    # Дальше используем лог, как обычно
    log.debug("Debug test record")
    log.info("Info test record")
    log.warn("Warning test record")
    log.error("Error test record")
    return 42


def main():
    # Настраиваем локальный лог для красивого вывода
    logging.initialize(logger=logging.getLogger('ya.fml'), appendHost=True)

    with Client() as client:
        hosts = ['sas1-1234.search.yandex.net', 'sas1-1235.search.yandex.net']
        session = client.run(hosts, some_long_task)
        with session:
            for host, result, err in session.wait():
                print("Получен результат от %r: %s" % (host, (result, err)))


if __name__ == '__main__':
    main()
