# -*- coding: utf-8 -*-
from api.cqueue import Client, Empty


class MyTask(object):
    def __init__(self, pipe):
        # Мы обязательно кладём трубу в объект выполняемой задачи,
        # чтобы она была доступна и на удалённой стороне
        self.pipe = pipe

    def __call__(self):
        while True:
            try:
                # Если за пять секунд ничего не пришло,
                # значит, в нашем случае что-то пошло не так, закругляемся
                number = self.pipe.get(timeout=5)
                # Задача всегда шлёт данные только клиенту, поэтому здесь
                # у pipe.put только один аргумент
                self.pipe.put(number * 2)
            except Empty:
                break
        self.pipe.put(None)  # Положим None, как маркер конца передачи


def main():
    with Client() as client:
        pipe = client.create_pipe()
        task = MyTask(pipe)

        with client.run(['localhost'], task):
            for i in range(10):
                # клиент может посылать сообщения разным машинам, поэтому мы всегда
                # передаём список, кому слать
                pipe.put(i, ['localhost'])

            while True:
                try:
                    # Данные могут приходить с разных хостов,
                    # поэтому мы всегда получаем пару — хост и данные
                    host, item = pipe.get(block=True, timeout=5)
                    if item is None:  # удалённая сторона сказала, что закончила
                        break

                    assert host == 'localhost', "WTF? We started task on only one host!"
                    assert item >= 0, "It should be a number!"
                except Empty:
                    break


if __name__ == '__main__':
    main()
