# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import time


def some_long_task():
    time.sleep(100)
    return 42


def wait_for_results(session, results_expected):
    received = 0
    while received < results_expected:
        for host, result, err in session.poll(0):
            received += 1
            print("Получен результат №%d: %s" % (received, (host, result, err)))


def main():
    hosts = ['localhost', 'host1', 'host2']
    with Client() as client:
        with client.run(hosts, some_long_task) as session:
            wait_for_results(session, len(hosts))


if __name__ == '__main__':
    main()
