# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import time


def some_long_task():
    time.sleep(100)
    return 42


def wait_for_results(session):
    # Подождём 60 секунд
    for host, result, err in session.wait(60):
        print(host, result, err)
    # Если мы посмотрим на код some_long_task, то поймём, что нам ещё
    # ни одного результата не пришло, поэтому запустим wait ещё раз
    for host, result, err in session.wait(60):
        print(host, result, err)


def main():
    with Client() as client:
        session = client.run(['localhost', 'host1', 'host2'], some_long_task)
        with session:
            wait_for_results(session)


if __name__ == '__main__':
    main()
