# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import socket


# Задача, которую мы будем выполнять
def myTask():
    return socket.gethostname()


def main():
    client = Client()

    # Запустим задачу на трёх машинах
    session = client.run(['localhost', 'host1', 'host2'], myTask)

    # Блок with нам гарантирует, что по окончании клиент и сессия будут закрыты
    with client, session:
        # Дожидаемся всех результатов
        for host, result, err in session.wait():
            # Если в выполняемом коде случается исключение, то оно
            # помещается в err
            if err is not None:
                print("Execution on %r failed: %s" % (host, err))
            else:
                print("Host %r: %s" % (host, result))


if __name__ == '__main__':
    main()
