# -*- coding: utf-8 -*-
from __future__ import print_function

from api.cqueue import Client
import os


def task_simple():
    return {'a': 'b', 'c': set([1, 2, 3])}


def test_simple():
    with Client() as client:
        with client.run('localhost', task_simple) as session:
            for host, result, err in session.wait():
                if err is not None:
                    print(host, err)
                if result is not None:
                    assert isinstance(result, dict)


class ComplexResult(object):
    allow_unpickle = True

    def __init__(self, a, b):
        self.a = a
        self.b = b


def task_complex():
    return ComplexResult(1, 2)


def test_complex():
    with Client() as client:
        with client.run(['localhost'], task_complex) as session:
            for host, result, err in session.wait():
                if err is not None:
                    print(host, err)
                if result is not None:
                    assert isinstance(result, ComplexResult)


def task_registered():
    return os.path.join  # Обратите внимание, мы возвращаем функцию, а не её вызов


def test_registered():
    with Client() as client:
        # Альтернативой нижеследующей строчке является вызов
        # client.register_safe_unpickle('posixpath', 'join')
        client.register_safe_unpickle(obj=os.path.join)
        with client.run(['localhost'], task_registered) as session:
            for host, result, err in session.wait():
                if err is not None:
                    print(host, err)
                if result is not None:
                    assert result is os.path.join


class Trespasser(object):
    def __reduce__(self, *args, **kwargs):
        # эта функция должна быть десериализована и выполнена на клиентской стороне
        return os.system, ("ls -l /",)


def task_trespasser():
    return Trespasser()


def test_forbidden():
    with Client() as client:
        with client.run(['localhost'], task_trespasser) as session:
            for host, result, err in session.wait():
                assert err is not None
                assert result is None
                print(host, err)


def main():
    test_simple()
    test_complex()
    test_registered()
    test_forbidden()


if __name__ == '__main__':
    main()
