# -*- coding: utf-8 -*-
"""Исключения, которые могут быть выброшены cqudp"""

import sys
import six

try:
    from kernel.util.errors import SkynetError
except ImportError:
    try:
        from ya.skynet.util.errors import SkynetError
    except ImportError:
        class SkynetError(Exception):
            def __init__(self, message, *args, **kwargs):
                Exception.__init__(self, *args, **kwargs)
                self.__dict__.update(kwargs)
                self.message = message


__all__ = [
    'Timeout',
    'ReadableKeyError',
    'CQueueExecutionFailure',
    'CQueueAuthenticationError',
    'CQueueAuthorizationError',
    'CQueueAuthError',
    'CQueueRuntimeError',
    'CQueueNetworkError',
    'CQueueError',
]


class CQueueError(SkynetError):
    """Базовый класс исключений cqudp"""
    pass


class CQueueNetworkError(CQueueError, EnvironmentError):
    """Ошибки, связанные с сетевыми операциями"""
    pass


class CQueueRuntimeError(CQueueError, RuntimeError):
    """Ошибки, связанные с выполнением"""
    def __str__(self):
        return 'CQueue runtime error: {}'.format(self.message)


class CQueueAuthError(CQueueRuntimeError):
    """Базовый класс для ошибок доступа"""
    def __str__(self):
        return str(self.message)


class CQueueAuthenticationError(CQueueAuthError):
    """Ошибка аутентификации"""
    pass


class CQueueAuthorizationError(CQueueAuthError):
    """Ошибка авторизации"""
    pass


class CQueueExecutionFailure(CQueueRuntimeError):
    """Ошибка запуска задачи"""
    def __str__(self):
        return str(self.message)


class ReadableKeyError(CQueueRuntimeError, KeyError):
    """Обёртка для KeyError с читаемым `__str__`"""
    def __str__(self):
        return str(self.message)


class Timeout(CQueueRuntimeError):
    """Выполнение задачи завершено по таймауту"""
    def __str__(self):
        return str(self.message)


def _wrapException(exc=None, needRaise=True):
    if exc is None:
        e_class, e_val, e_tb = sys.exc_info()
    else:
        e_class = exc.__class__
        e_val = exc

    if e_class is None:
        return

    if e_class.__name__ in __all__:
        e_new_class = globals()[e_class.__name__]
        e_val.__class__ = e_new_class
        if exc is None:
            six.reraise(e_new_class, e_val, e_tb)
        elif needRaise:
            raise e_val
        else:
            return e_val
    elif exc is None:
        six.reraise(e_class, e_val, e_tb)
    elif needRaise:
        raise e_val
    else:
        return e_val
