# -*- coding: utf-8 -*-

import os
import sys
from logging import NOTSET

from .client import _getServiceName

try:
    from kernel.util.functional import memoized
except ImportError:
    def memoized(fn):
        return fn


@memoized
def RemoteLogHandler(level=NOTSET, implementation='c'):
    """
    Специальный обработчик логов, который можно использовать
    в стандартной питоновской системе логирования. Применять
    можно исключительно на удалённой стороне для пересылки
    логов от задачи клиенту.

    :param level: один из определённых в :mod:`logging` уровней логирования
    :param implementation: реализация API cqudp. Внутри таска текущая реализация
                           определяется переменной окружения CQ_IMPLEMENTATION,
                           и только при её отсутствии используется этот параметр
    :return: :class:`logging.Handler`
    """
    implementation = os.getenv('CQ_IMPLEMENTATION', implementation)
    name = _getServiceName(implementation)

    if name == 'cqudp' and getattr(sys, 'is_standalone_binary', False):
        from ya.skynet.services.cqudp.rpc.loghandler import CQRemoteLogHandler
        return CQRemoteLogHandler(level)

    from api.skycore import ServiceManager
    ns = os.getenv('SKYNET_CQ_NAMESPACE', 'skynet')

    return ServiceManager().get_service_python_api(ns, name, kind='python_remote_log_handler')(level)
